/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.incident;

import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventManager;
import com.ibm.hwmca.fw.pa.incident.Incident;
import com.ibm.hwmca.fw.pa.incident.IncidentTimer;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.xfw.pa.event.CommonServiceEvent;
import com.ibm.hwmca.xfw.pa.event.PooledEvent;
import com.ibm.hwmca.xfw.pa.fru.CommonFruListKey;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.Date;
import java.util.List;

public class CommonServiceIncident
extends Incident
implements Comparable {
    private static final String TRACE_MASKT = "XPACSLIT";
    private static final String TRACE_MASKF = "XPACSLIF";
    private static final String TRACE_MASKD = "XPACSLID";
    private static final boolean UNIT_TEST = true;
    protected CommonServiceEvent _secondaryEvent = null;
    protected CommonServiceEvent _timerEvent = null;
    protected ProblemAnalysisEventManager _eventManager = null;
    protected CommonFruListKey _fruKey = null;
    protected boolean _resolveFruList = false;
    protected CommonProblem _problem;
    protected float _priority = 50.0f;
    protected Date _createDate;
    private PASystem system = null;

    public CommonServiceIncident() {
        Trace.trace(TRACE_MASKD, "<--> CommonServiceIncident.<init>");
        this._createDate = new Date();
    }

    public Date getTimestamp() {
        return this._createDate;
    }

    public float getPriority() {
        return this._priority;
    }

    public void setPriority(float priority) {
        if (priority > 100.0f || priority < 0.0f) {
            throw new IllegalArgumentException("Priority out of bounds" + priority);
        }
        this._priority = priority;
    }

    public int compareTo(Object incident) {
        CommonServiceIncident inputIncident = (CommonServiceIncident)incident;
        if (this._priority == inputIncident.getPriority()) {
            Date inputDate = inputIncident.getTimestamp();
            return this._createDate.compareTo(inputDate);
        }
        if (this._priority > inputIncident.getPriority()) {
            return -1;
        }
        return 1;
    }

    public PASystem getSystem() {
        return this.system;
    }

    public void setSystem(PASystem system) {
        this.system = system;
    }

    public ProblemAnalysisEventManager getEventManager() {
        return this._eventManager;
    }

    public void setEventManager(ProblemAnalysisEventManager eventManager) {
        Trace.trace(TRACE_MASKD, "set the event manager");
        this._eventManager = eventManager;
    }

    public CommonServiceEvent getTimerEvent() {
        return this._timerEvent;
    }

    public void setTimerEvent(CommonServiceEvent timerEvent) {
        this._timerEvent = timerEvent;
    }

    public void timerPopped(IncidentTimer timer) {
        Trace.trace(TRACE_MASKD, "CommonServiceIncident.timerPopped() entry");
        if (this.getContainer() != null) {
            this.getContainer().cancel();
        }
        if (this._timerEvent != null) {
            Trace.trace(TRACE_MASKD, "post the timerEvent " + this._timerEvent);
            if (this._timerEvent instanceof PooledEvent) {
                ((PooledEvent)((Object)this._timerEvent)).setIncident(this);
            }
            if (this._eventManager != null) {
                this._eventManager.handleEvent(this._timerEvent);
            } else {
                Trace.trace(TRACE_MASKD, "Got a null event manager");
            }
        }
    }

    public void timerCanceled(IncidentTimer timer) {
        Trace.trace(TRACE_MASKD, "CommonServiceIncident.timerCanceled() entry");
    }

    public CommonServiceEvent getSecondaryEvent() {
        return this._secondaryEvent;
    }

    public void setSecondaryEvent(CommonServiceEvent secondaryEvent) {
        this._secondaryEvent = secondaryEvent;
    }

    public void addAssociateFile(String fileName) {
        List fileList = (List)this.getMetaData().getMeta("pdc_ASSOC_FILE_LIST");
        if (fileList != null) {
            fileList.add(fileName);
        } else {
            fileList = new XMLEncodeableArrayList("Associated File List");
            fileList.add(fileName);
            this.getMetaData().setMeta("pdc_ASSOC_FILE_LIST", fileList);
        }
    }

    public void addAssociateFile(List inputList) {
        List fileList = (List)this.getMetaData().getMeta("pdc_ASSOC_FILE_LIST");
        if (fileList != null) {
            fileList.addAll(inputList);
        } else {
            fileList = new XMLEncodeableArrayList("Associated File List");
            fileList.addAll(inputList);
            this.getMetaData().setMeta("pdc_ASSOC_FILE_LIST", fileList);
        }
    }

    public List getAssociateFileList() {
        return (List)this.getMetaData().getMeta("pdc_ASSOC_FILE_LIST");
    }

    public ProblemAnalysisEventManager getProblemManager() {
        return this._eventManager;
    }

    public void setProblemManager(ProblemAnalysisEventManager eventManager) {
        Trace.trace(TRACE_MASKD, "set the event manager");
        this._eventManager = eventManager;
    }

    public CommonProblem getProblem() {
        return this._problem;
    }

    public void setProblem(CommonProblem problem) {
        this._problem = problem;
    }

    public void setFruKey(CommonFruListKey key) {
        this._fruKey = key;
    }

    public CommonFruListKey getFruKey() {
        return this._fruKey;
    }

    public boolean isResolveFruList() {
        return this._resolveFruList;
    }

    public void setResolveFruList(boolean value) {
        this._resolveFruList = value;
    }

    public boolean swap(CommonServiceIncident incident) {
        return false;
    }

    public boolean isAssociate(CommonServiceIncident incident) {
        return false;
    }
}

